function [prob_est, scale_est, shape_est, f_best, init_best] = fitting_trun(binWidth, lifetimes, this_set, type, t_trun, fix_shape, integer_shapes, N_init)
    
    p_upper = 1;
    p_lower = 0;
    
    % limits on shape
    shape_lower = eps;
    shape_upper = 3; 
    
    % limits on scale
    scale_lower = eps;
    scale_upper = 400;
    
    if fix_shape==1
        n_subpop=size(integer_shapes,2);
    else
        n_subpop=this_set;
    end
    tlow = t_trun(1);
    thigh = t_trun(2);
    
    binCtrs = tlow:binWidth:thigh;
    rawHisto = histcounts(lifetimes,[binCtrs, thigh+binWidth]);

    % normalize histo from 0 to 1
    nu = size(lifetimes,1);
    normHisto = rawHisto/(nu*binWidth);
    emp_cdf = cumsum(rawHisto)/nu;
    
    if type=='pdf'
        f_dist = @(y1,y2,y3) y1*wblpdf(binCtrs,y2,y3)/(wblcdf(thigh,y2,y3)-wblcdf(tlow,y2,y3));
        f_expected = normHisto;
    elseif type=='cdf'
        f_dist = @(y1,y2,y3) y1*wblcdf(binCtrs,y2,y3);
        f_expected = emp_cdf;
    end
    
    if n_subpop==1
        f_cost = @(x) sum((f_dist(1,x(1),x(2))-f_expected).^2);
        A=[]; b=[];
        f = @(x,a,b) wblpdf(x,a,b);
    elseif n_subpop==2
        f_cost = @(x) sum(((f_dist(x(1),x(2),x(3)) + f_dist(1-x(1),x(4),x(5)))-f_expected).^2);
        A=[]; b=[];
        f = @(x,p,a,b,c,d) p*wblpdf(x,a,b) + (1-p)*wblpdf(x,c,d);
    elseif n_subpop==3
        f_cost = @(x) sum(((f_dist(x(1),x(3),x(4)) + f_dist(x(2),x(5),x(6)) + f_dist(1-x(1)-x(2),x(7),x(8)))-f_expected).^2);
        A = [1,1,0,0,0,0,0,0;
            -1,-1,0,0,0,0,0,0]; b = [p_upper; -p_lower];
        f = @(x,p,q,a,b,c,d,e,f) p*wblpdf(x,a,b) + q*wblpdf(x,c,d) + (1-p-q)*wblpdf(x,e,f);
    elseif n_subpop==4
        f_cost = @(x) sum(((f_dist(x(1),x(4),x(5)) + f_dist(x(2),x(6),x(7)) + f_dist(x(3),x(8),x(9)) + f_dist(1-x(1)-x(2)-x(3),x(10),x(11)))-f_expected).^2);
        A = [1,1,1,0,0,0,0,0,0,0,0;
            -1,-1,-1,0,0,0,0,0,0,0,0]; b = [p_upper; -p_lower];
        f = @(x,p,q,r,a,b,c,d,e,f,g,h) p*wblpdf(x,a,b) + q*wblpdf(x,c,d) + r*wblpdf(x,e,f) + (1-p-q-r)*wblpdf(x,g,h);
    elseif n_subpop==5
        f_cost = @(x) sum(((f_dist(x(1),x(5),x(6)) + f_dist(x(2),x(7),x(8)) + f_dist(x(3),x(9),x(10)) + f_dist(x(4),x(11),x(12)) + f_dist(1-x(1)-x(2)-x(3)-x(4),x(13),x(14)))-f_expected).^2);
        A = [1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            -1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0]; b = [p_upper; -p_lower];
        f = @(x,p,q,r,s,a,b,c,d,e,f,g,h,i,j) p*wblpdf(x,a,b) + q*wblpdf(x,c,d) + r*wblpdf(x,e,f) + s*wblpdf(x,g,h) + (1-p-q-r-s)*wblpdf(x,i,j);
    elseif n_subpop==6
        f_cost = @(x) sum(((f_dist(x(1),x(6),x(7)) + f_dist(x(2),x(8),x(9)) + f_dist(x(3),x(10),x(11)) + f_dist(x(4),x(12),x(13)) + f_dist(x(5),x(14),x(15)) + f_dist(1-x(1)-x(2)-x(3)-x(4)-x(5),x(16),x(17)))-f_expected).^2);
        A = [1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            -1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0]; b = [p_upper; -p_lower];
        f = @(x,p,q,r,s,t,a,b,c,d,e,f,g,h,i,j,k,l) p*wblpdf(x,a,b) + q*wblpdf(x,c,d) + r*wblpdf(x,e,f) + s*wblpdf(x,g,h) + t*wblpdf(x,i,j) + (1-p-q-r-s-t)*wblpdf(x,k,l);
    elseif n_subpop==7
        f_cost = @(x) sum(((f_dist(x(1),x(7),x(8)) + f_dist(x(2),x(9),x(10)) + f_dist(x(3),x(11),x(12)) + f_dist(x(4),x(13),x(14)) + f_dist(x(5),x(15),x(16)) + f_dist(x(6),x(17),x(18)) + f_dist(1-x(1)-x(2)-x(3)-x(4)-x(5)-x(6),x(19),x(20)))-f_expected).^2);
        A = [1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            -1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0]; b = [p_upper; -p_lower];
        f = @(x,p,q,r,s,t,u,a,b,c,d,e,f,g,h,i,j,k,l,m,n) p*wblpdf(x,a,b) + q*wblpdf(x,c,d) + r*wblpdf(x,e,f) + s*wblpdf(x,g,h) + t*wblpdf(x,i,j) + u*wblpdf(x,k,l)+ (1-p-q-r-s-t-u)*wblpdf(x,m,n);
    end
    
    options = optimoptions('fmincon','Display','off','Algorithm','interior-point','MaxFunctionEvaluations',5000,'MaxIterations',5000,'StepTolerance',10^-14,'OptimalityTolerance',10^-14);
    run_yet = 1;
    k = 1;
    while run_yet  
        shape_indices = 1 + [n_subpop:2:(3*n_subpop-2)];
        scale_indices = shape_indices-1;
        prob_indices = 1:(n_subpop-1);
        
        probs = rand([1,n_subpop-1]);
        wbl_params = repmat([10,2],[1,n_subpop]).*rand([1,2*n_subpop]);
        init_x = [probs wbl_params];
        lb_list = repmat([scale_lower,shape_lower],[1,n_subpop]); 
        ub_list = repmat([scale_upper,shape_upper],[1,n_subpop]); 
        lb = [p_lower*ones(1,n_subpop-1) lb_list]; 
        ub = [p_upper*ones(1,n_subpop-1) ub_list];
        if fix_shape
            init_x(shape_indices) = integer_shapes;
            lb(shape_indices) = integer_shapes;
            ub(shape_indices) = integer_shapes;            
        end
        
        if numel(probs)>0 && (sum(probs)>p_upper || sum(probs)<p_lower)
            continue
        end
        
        shapetoolow=0;
        for i=1:n_subpop
            if init_x(shape_indices(i))<shape_lower || init_x(shape_indices(i))>shape_upper
                shapetoolow=1;
            end
        end
        if shapetoolow==1
            continue
        end
        
        if n_subpop==1
            if wblcdf(tlow,init_x(1),init_x(2))==wblcdf(thigh,init_x(1),init_x(2))
                continue
            end
        end
        if n_subpop==2
            if wblcdf(tlow,init_x(2),init_x(3))==wblcdf(thigh,init_x(2),init_x(3)) || wblcdf(tlow,init_x(4),init_x(5))==wblcdf(thigh,init_x(4),init_x(5))
                continue
            end
        end
        if n_subpop==3
            if wblcdf(tlow,init_x(3),init_x(4))==wblcdf(thigh,init_x(3),init_x(4)) || wblcdf(tlow,init_x(5),init_x(6))==wblcdf(thigh,init_x(5),init_x(6)) || wblcdf(tlow,init_x(7),init_x(8))==wblcdf(thigh,init_x(7),init_x(8))
                continue
            end
        end
        if n_subpop==4
            if wblcdf(tlow,init_x(4),init_x(5))==wblcdf(thigh,init_x(4),init_x(5)) || wblcdf(tlow,init_x(6),init_x(7))==wblcdf(thigh,init_x(6),init_x(7)) || wblcdf(tlow,init_x(8),init_x(9))==wblcdf(thigh,init_x(8),init_x(9)) || wblcdf(tlow,init_x(10),init_x(11))==wblcdf(thigh,init_x(10),init_x(11))
                continue
            end
        end
        if n_subpop==5
            if wblcdf(tlow,init_x(5),init_x(6))==wblcdf(thigh,init_x(5),init_x(6)) || wblcdf(tlow,init_x(7),init_x(8))==wblcdf(thigh,init_x(7),init_x(8)) || wblcdf(tlow,init_x(9),init_x(10))==wblcdf(thigh,init_x(9),init_x(10)) || wblcdf(tlow,init_x(11),init_x(12))==wblcdf(thigh,init_x(11),init_x(12)) || wblcdf(tlow,init_x(13),init_x(14))==wblcdf(thigh,init_x(13),init_x(14))
                continue
            end
        end
        if n_subpop==6
            if wblcdf(tlow,init_x(6),init_x(7))==wblcdf(thigh,init_x(6),init_x(7)) || wblcdf(tlow,init_x(8),init_x(9))==wblcdf(thigh,init_x(8),init_x(9)) || wblcdf(tlow,init_x(10),init_x(11))==wblcdf(thigh,init_x(10),init_x(11)) || wblcdf(tlow,init_x(12),init_x(13))==wblcdf(thigh,init_x(12),init_x(13)) || wblcdf(tlow,init_x(14),init_x(15))==wblcdf(thigh,init_x(14),init_x(15))  || wblcdf(tlow,init_x(16),init_x(17))==wblcdf(thigh,init_x(16),init_x(17))
                continue
            end
        end
        if n_subpop==7
            if wblcdf(tlow,init_x(7),init_x(8))==wblcdf(thigh,init_x(7),init_x(8)) || wblcdf(tlow,init_x(9),init_x(10))==wblcdf(thigh,init_x(9),init_x(10)) || wblcdf(tlow,init_x(11),init_x(12))==wblcdf(thigh,init_x(11),init_x(12)) || wblcdf(tlow,init_x(13),init_x(14))==wblcdf(thigh,init_x(13),init_x(14)) || wblcdf(tlow,init_x(15),init_x(16))==wblcdf(thigh,init_x(15),init_x(16))  || wblcdf(tlow,init_x(17),init_x(18))==wblcdf(thigh,init_x(17),init_x(18))   || wblcdf(tlow,init_x(19),init_x(20))==wblcdf(thigh,init_x(19),init_x(20))
                continue
            end
        end
        k;
        init_store(k,:) = init_x;
        [est(k,:),fval,~,~] = fmincon(f_cost,init_x,A,b,[],[],lb,ub,[],options);
        f_eval(k) = fval;
        if k==N_init
            run_yet=0;
        end
        k=k+1;
    end
    [f_best,I] = min(f_eval);
    best_estimate = est(I,:);
    init_best = init_store(I,:);
    
    [~,ii] = sort(best_estimate(1, shape_indices),'descend');
    prob_est = [best_estimate(1, prob_indices), 1-sum(best_estimate(1, prob_indices))];
    prob_est = prob_est(ii);
    scale_est = best_estimate(1, scale_indices(ii));
    shape_est = best_estimate(1, shape_indices(ii));
end